function [loglikfunct] = LogLikelihood_Function(D, h, beta)
% Calculates the log-likelihood function as in Den Boer, Zwart (2013)
%
% Inputs
%   D: 2*t matrix of price-demand couples up to time period t.
%   h: Function handle for demand probability.
%   beta: Vector of parameters of the function h [beta0, beta1] or [beta0,
%   beta1, beta2].
%
% Outputs
%   loglikfunct: The log-likelihood function.

beta0 = beta(1);
beta1 = beta(2);

loglikfunct = 0;

if length(beta) == 2
    
    for t = 1:size(D, 2)
        p = D(1,t);
        d = D(2,t);
        loglikfunct = loglikfunct + log((h(beta0+beta1*p)^d)*...
            (1-h(beta0+beta1*p))^(1-d));
    end
    
elseif length(beta) == 3
    
    beta2 = beta(3);
    
    for t = 1:size(D, 2)
        p = D(1,t);
        d = D(2,t);
        s = D(3,t);
        loglikfunct = loglikfunct + log((h(beta0+beta1*p+beta2*s)^d)*...
            (1-h(beta0+beta1*p+beta2*s))^(1-d));
    end
    
end


end

